let videoLoadingMessageTimeout;
let videoTimeoutHandler;
let videoIsPlaying = false;
let currentVideo;
let currentCoin;
let videoIsLoading = false;

let coinBaseScale;

let waitForVideoEnd;
let waitForLoad;

AFRAME.registerComponent('location-asset', {
    schema: {
        id: {type: 'string', default: ""},
        xRotation: { type: 'number', default: 0 },
        yRotation: { type: 'number', default: 0 },
        zRotation: { type: 'number', default: 0 },
        video: { type: 'string', default: "" },
        coin: { type: 'string', default: "" },
        isLoaded: { type: 'bool', default: false },
    },
    init: function () {
        let data = this.data;

        let coin = document.getElementById(data.coin);
        var videoAsset = document.getElementById(data.video);
        let videoStopsArray;

        const uA = navigator.userAgent;
        const vendor = navigator.vendor;
        var iOSOrSafari = (/Safari/i.test(uA) && /Apple Computer/.test(vendor) && !/Mobi|Android/i.test(uA)) || (/iPhone|iPad|iPod/i.test(uA));

        this.el.addEventListener("locationTransition", function (e) {
            if(videoIsPlaying && currentVideo != data.video)
            {
                // console.log('stop if current playing video != next video')
                StopVideo(currentVideo, currentCoin);
                videoIsPlaying = false;
            }
            if(activeTouchPoint != data.id)
            {
                activeTouchPoint = data.id;
                console.log("Active Point: " + data.id);
            }
        });

        this.el.addEventListener("touchPointVideo", function (event) {

            if(videoIsPlaying && currentVideo != data.video)
            {
                // console.log('stop if current playing video != next video')
                StopVideo(currentVideo, currentCoin);
                videoIsPlaying = false;
            }

            if(videoStopsArray == null)
            {
                videoStopsArray = event.detail.videoStops.split(" ");
            }

            // if((videoIsPlaying || videoIsLoading) && videoStopsArray.includes(activeTouchPoint))
            if((videoIsPlaying || videoIsLoading))
            {
                // console.log('if video at current stop is playing, stop video')
                StopVideo(data.video, coin);
                videoIsLoading = false;
            }

            if(!event.detail.videoSuccess)
            {
                StopVideo(data.video, coin, false);
                videoIsPlaying = false;
                videoIsLoading = false;
                setTimeout(() => {
                    document.getElementById('errorMessage').classList.remove('show-message');
                }, 3000)
            }
            // else if(!videoIsPlaying && videoStopsArray.includes(activeTouchPoint))
            else if(!videoIsPlaying)
            {
                // console.log('if nothing is playing, play video')
                AnimateCoinOff(coin);

                videoIsLoading = true;
                if (iOSOrSafari) {
                    waitForLoad = WaitForVideoLoad(videoAsset);
                    waitForLoad.promise.then(() => {
                        if(data.video != "" && !videoIsPlaying && event.detail.videoSuccess)
                        {
                            PlayVideo(data.video, coin);
                            videoIsPlaying = true;
                            currentVideo = data.video;
                            currentCoin = coin;
                        }
                    });
                    waitForLoad.promise.catch(() => console.error('Promise rejected!'));
                }
                else
                {
                    waitForLoad = WaitForVideoLoad(videoAsset);
                    waitForLoad.promise.then(() => {
                        if(data.video != "" && !videoIsPlaying && event.detail.videoSuccess)
                        {
                            videoAsset.play();
                            PlayVideo(data.video, coin);
                            videoIsPlaying = true;
                            currentVideo = data.video;
                            currentCoin = coin;
                        }
                    });
                    waitForLoad.promise.catch(() => console.error('Promise rejected!'));
                }

                videoTimeoutHandler = setTimeout(() => {
                    if(videoIsLoading)
                    {
                        waitForLoad.cancel();
                        videoIsLoading = false;
                        videoAsset.currentTime = 1000;
                        AnimateCoinOn(coin);
                        document.getElementById('loadingMessage').classList.remove('show-message');
                        document.getElementById('timeoutMessage').classList.add('show-message');
                        setTimeout(() => {
                            document.getElementById('timeoutMessage').classList.remove('show-message');
                        }, 3000)
                    }
                }, 60000)

                videoLoadingMessageTimeout = setTimeout(() => {
                    if(videoIsLoading)
                    {
                        document.getElementById('loadingMessage').classList.add('show-message');
                        document.querySelector('#spinAudio').volume = 0.5;
                    }
                }, 2000)

                event.detail.firstTime = false;
            }

        });
    }
});

AFRAME.registerComponent('coin-idle-animation', {
    schema: {
        id: {type: 'string', default: ""},
        active: {type: 'bool', default: true},
        yOrigin: {type: 'float', default: 1.6},
        baseScale: {type: 'float', default: 0.1}
    },
    init: function () {
        let data = this.data;
        let coin = this.el;
        data.baseScale = coin.object3D.scale.x;

        coin.setAttribute('animation__idle', {
            startEvents: data.id + "_idle_start",
            pauseEvents: data.id + "_idle_stop",
            property: 'rotation',
            from: '0 0 0',
            to: '0 360 0',
            easing: 'linear',
            dur: 8000,
            loop: true,
        });

        coin.setAttribute('animation__spin', {
            startEvents: data.id + "_spin_start",
            pauseEvents: data.id + "_spin_stop",
            property: 'rotation',
            from: '0 0 0',
            to: '0 360 0',
            dur: 200,
            easing: 'linear',
            loop: true,
        });

        coin.setAttribute('animation__bounce', {
            startEvents: data.id + "_bounce",
            property: 'scale',
            from: String(data.baseScale * 1.2) + " " + String(data.baseScale * 1.2) + " " + String(data.baseScale * 1.2),
            to: String(data.baseScale) + " " + String(data.baseScale) + " " + String(data.baseScale),
            dur: 1200,
            direction: 'alternate',
            easing: 'easeOutElastic(2.5, .3)',
            loop: false,
        });

        coin.emit(data.id + "_idle_start");

    },
});

function PlayVideo(video, coin) {
    clearTimeout(videoTimeoutHandler);
    clearTimeout(videoLoadingMessageTimeout);
    coin.classList.remove('cantap');
    document.getElementById('loadingMessage').classList.remove('show-message');
    document.getElementById('timeoutMessage').classList.remove('show-message');
    videoIsLoading = false;
    var videoAsset = document.querySelector('#' + video);
    var videoPlane = document.querySelector('#' + video + "Plane");

    setTimeout(function () {
        videoAsset.currentTime = 0;
        coin.setAttribute('visible', false);
        videoPlane.classList.add('cantap');
        videoAsset.muted = false;
    }, 400)
    setTimeout(function () {
        videoPlane.setAttribute('visible', true);
    }, 380)

    waitForVideoEnd = WaitForVideoEnd(videoAsset);
    waitForVideoEnd.promise.then(() => {
        if(videoIsPlaying)
        {
            videoPlane.classList.remove('cantap');
            videoPlane.setAttribute('visible', false);
            AnimateCoinOn(coin)
            videoIsPlaying = false;
        }
    });
    waitForVideoEnd.promise.catch(() => console.error('Promise rejected!'));
}

function StopVideo(video, coin, isSuccess = true) {
    if(waitForVideoEnd != undefined) { waitForVideoEnd.cancel(); }
    clearTimeout(videoTimeoutHandler);
    clearTimeout(videoLoadingMessageTimeout);
    document.getElementById('loadingMessage').classList.remove('show-message');
    document.getElementById('timeoutMessage').classList.remove('show-message');
    var videoAsset = document.querySelector('#' + video);
    var videoPlane = document.querySelector('#' + video + "Plane");
    videoPlane.classList.remove('cantap');
    if((!isSuccess || videoIsLoading) && waitForLoad != undefined) { 
        waitForLoad.cancel();
        videoAsset.currentTime = 1000;
    }
    else if (isSuccess && videoIsPlaying) { videoAsset.currentTime = videoAsset.duration - 1; }
    videoIsPlaying = false;
    
    setTimeout(function () {
        AnimateCoinOn(coin);
        videoPlane.setAttribute('visible', false);
    }, 500);
}

function AnimateCoinOff(coin) {

    var coinId = coin.getAttribute('coin-idle-animation').id;
    
    coin.emit(coinId + "_idle_stop");
    coin.emit(coinId + "_spin_start");
    coin.emit(coinId + "_bounce");
}

function AnimateCoinOn(coin) {
    
    // coin.classList.add('cantap');
    coin.setAttribute('visible', true);
    // baseCoinMesh.emit('fadeIn');
    // baseMarkerMesh.emit('fadeIn');
    // for(var i = 0; i < transitionSigns.length; i++)
    // {
    //     transitionSigns[i].emit('fadeIn');
    // }
    var coinId = coin.getAttribute('coin-idle-animation').id;

    setTimeout(function() {
        coin.emit(coinId + "_spin_stop");
        coin.emit(coinId + "_idle_start");
        coin.classList.add('cantap');
    }, 100)

}

function WaitForVideoLoad(video)
{
    let finished = false;
    let cancel = () => finished = true;
    
    const promise = new Promise((resolve, reject) => {
    
        const id = setInterval(() => {
            if(video.readyState === 4)
            {
                clearInterval(id);
                resolve();
            }
        }, 500);
    
    
        // When consumer calls `cancel`:
        cancel = () => {
            // In case the promise has already resolved/rejected, don't run cancel behavior!
            if (finished) {
                return;
            }
    
            // Cancel-path scenario
            clearInterval(id);
            reject();
        };
    
        // If was cancelled before promise was launched, trigger cancel logic
        if (finished) {
            // (to avoid duplication, just calling `cancel`)
            cancel();
        }
    
    })
        // After any scenario, set `finished = true` so cancelling has no effect
        .then((resolvedValue) => {
            finished = true;
            return resolvedValue;
        })
        .catch((err) => {
            finished = true;
            return err;
        });

    return { promise, cancel };
}

function WaitForVideoEnd(videoAsset)
{
    let finished = false;
    let cancel = () => finished = true;
    
    const promise = new Promise((resolve, reject) => {
    
        const id = setInterval(() => {
            if(videoAsset.currentTime >= (videoAsset.duration - 0.5))
            {
                clearInterval(id);
                resolve();
            }
        }, 500);
    
    
        // When consumer calls `cancel`:
        cancel = () => {
            // In case the promise has already resolved/rejected, don't run cancel behavior!
            if (finished) {
                return;
            }
    
            // Cancel-path scenario
            clearInterval(id);
            reject();
        };
    
        // If was cancelled before promise was launched, trigger cancel logic
        if (finished) {
            // (to avoid duplication, just calling `cancel`)
            cancel();
        }
    
    })
        // After any scenario, set `finished = true` so cancelling has no effect
        .then((resolvedValue) => {
            finished = true;
            return resolvedValue;
        })
        .catch((err) => {
            finished = true;
            return err;
        });

    return { promise, cancel };
}
