let camera;
let cameraParent;
let scene;
let skybox;

let baseCoinMesh;
let dropShadowMesh;
let baseMarkerMesh;
let transitionSigns;
let activeTouchPoint;
let raycaster;
let aFrameLoaded = false;
let modelsLoaded = false;

let sceneLoadTimeout;

let mouseIsDown = false;
let mouseMoved = false;

let subtitlesActive = false;
let subtitleButton;
let subtitleElement;
let previousCue = "";

const uA = navigator.userAgent;
const vendor = navigator.vendor;
const iOSOrSafari = (/Safari/i.test(uA) && /Apple Computer/.test(vendor) && !/Mobi|Android/i.test(uA)) || (/iPhone|iPad|iPod/i.test(uA));

const onDocumentReady = OnDocumentReady();
onDocumentReady.promise.then(() => init());
onDocumentReady.promise.catch(() => console.error('Promise rejected!'));

function init() {
    camera = document.getElementById('camera');
    cameraParent = document.getElementById('cameraParent');
    scene = document.querySelector('a-scene');
    console.log('init loaded');

    const waitForAframeLoad = WaitForAframeLoad(scene);
    waitForAframeLoad.promise.then(() => {
        setTimeout(OnAframeLoad(), 1000);
    });
    waitForAframeLoad.promise.catch(() => console.error('Promise rejected!'));


    baseMarkerMesh = document.getElementById('location0_point');
    baseMarkerMesh.setAttribute('animation__fadein', {
        startEvents: 'fadeIn',
        property: 'model-opacity',
        easing: 'easeInCubic',
        dur: 180,
        from: 0,
        to: .25,
    })
    baseMarkerMesh.setAttribute('animation__fadeout', {
        startEvents: 'fadeOut',
        property: 'model-opacity',
        easing: 'easeInCubic',
        dur: 350,
        from: .25,
        to: 0,
    })

    baseCoinMesh = document.getElementById('frontCoin');
    baseCoinMesh.setAttribute('animation__fadein', {
        startEvents: 'fadeIn',
        property: 'model-opacity',
        easing: 'easeInCubic',
        dur: 180,
        from: 0,
        to: 1,
    })
    baseCoinMesh.setAttribute('animation__fadeout', {
        startEvents: 'fadeOut',
        property: 'model-opacity',
        easing: 'easeInCubic',
        dur: 350,
        from: 1,
        to: 0,
    })

    dropShadowMesh = document.getElementById('baseDropShadow');
    dropShadowMesh.setAttribute('animation__fadein', {
        startEvents: 'fadeIn',
        property: 'model-opacity',
        easing: 'easeInCubic',
        dur: 180,
        from: 0,
        to: 0.2,
    })
    dropShadowMesh.setAttribute('animation__fadeout', {
        startEvents: 'fadeOut',
        property: 'model-opacity',
        easing: 'easeInCubic',
        dur: 350,
        from: 0.2,
        to: 0,
    })

    transitionSigns = document.getElementsByClassName('sign');

    for(var i = 0; i < transitionSigns.length; i++)
    {
        transitionSigns[i].setAttribute('animation__fadein', {
            startEvents: 'fadeIn',
            property: 'model-opacity',
            easing: 'easeInCubic',
            dur: 180,
            from: 0,
            to: 1,
        });

        transitionSigns[i].setAttribute('animation__fadeout', {
            startEvents: 'fadeOut',
            property: 'model-opacity',
            easing: 'easeInCubic',
            dur: 350,
            from: 1,
            to: 0,
        })
    }

    baseMarkerMesh.addEventListener('model-loaded', () => {
        // Grab the mesh / scene.
        console.log("marker model loaded")
        setTimeout(() => {
            baseMarkerMesh.emit('fadeIn');
        }, 1000);
    });
    baseCoinMesh.addEventListener('model-loaded', () => {
        modelsLoaded = true;
        // Grab the mesh / scene.
        setTimeout(() => {
            baseCoinMesh.emit('fadeIn');
            dropShadowMesh.emit('fadeIn');
        }, 1000);
        console.log("coin model loaded")
    });
    transitionSigns[0].addEventListener('model-loaded', () => {
        // Grab the mesh / scene.
        console.log("sign model loaded")
        setTimeout(() => {
            for(var i = 0; i < transitionSigns.length; i++)
            {
                transitionSigns[i].emit('fadeIn');
            }
        }, 1000);
    });

}

function OnAframeLoad()
{
    clearTimeout(sceneLoadTimeout);
    if(!aFrameLoaded)
    {
        aFrameLoaded = true;
        console.log('AFRAME loaded')
        camera = document.querySelector("a-camera");

        scene.addEventListener('mousedown', () => {
            mouseIsDown = true;
        }, false);
        scene.addEventListener('mousemove', () => {
            if(mouseIsDown)
            {
                mouseMoved = true;
            }
        }, false);
        scene.addEventListener('mouseup', () => {
            setTimeout(() => {
                mouseIsDown = false;
                mouseMoved = false;
            }, 100)
        }, false);
        
        loadingOverlay = document.getElementById('loadingScreen');
        loadingOverlay.classList.add('hidden');
        skybox = document.getElementById('skyboxBase');
        skyboxTransition = document.getElementById('skyboxTransition');
        activeTouchPoint = '#location7';

        setTimeout(() => {
            if(!modelsLoaded)
            {
                baseMarkerMesh.emit('fadeIn');
                dropShadowMesh.emit('fadeIn');
                baseCoinMesh.emit('fadeIn');
                for(var i = 0; i < transitionSigns.length; i++)
                {
                    transitionSigns[i].emit('fadeIn');
                }
            }
        }, 1000);

        var videos = document.querySelectorAll('video');
        subtitleButton = document.getElementById('subtitleButton');
        subtitleButton.addEventListener('click', ToggleSubtitles );
        subtitleElement = document.getElementById('subtitleDisplay');
        // for (var i = 0; i < videos.length; i++)
        // {
        //     if(videos[i].textTracks.length > 0)
        //     {
        //         videos[i].onended = () => { subtitleElement.innerText = ""; }
        //         checkForCueChange = CheckForCueChange(videos[i].textTracks[0]);
        //         checkForCueChange.promise.then( () => {
        //             console.log(videos[i].textTracks[0].activeCues[0].text);
        //             SetSubtitleText(videos[i].textTracks[0].activeCues);
        //         } );
        //         checkForCueChange.promise.catch(() => console.error('Promise rejected!'));
        //         // videos[i].textTracks[0].addEventListener('cuechange', (event) => {
        //         //     console.log(event.target.activeCues[0].text);
        //         //     SetSubtitleText(event.target.activeCues);
        //         // }, false);
        //     }
        // }
    }
}

function SetSubtitleText(activeCues)
{
    if(activeCues.length > 0)
    {
        subtitleElement.innerText = activeCues[0].text;
    }
    else
    {
        subtitleElement.innerText = "";
    }
}

function ToggleSubtitles()
{
    subtitlesActive = !subtitlesActive;
    if(!subtitlesActive)
    {
        subtitleElement.classList.add('hidden');
        subtitleButton.style.opacity = 0.5;
    }
    else
    {
        subtitleElement.classList.remove('hidden');
        subtitleButton.style.opacity = 1;
    }
}

function WaitForAframeLoad()
{
    let finished = false;
    let counts = 0;
    let cancel = () => finished = true;
    
    const promise = new Promise((resolve, reject) => {
    
        const id = setInterval(() => {
            counts += 1;
            console.log(counts);
            if(counts === 21 || scene.hasLoaded)
            {
                clearInterval(id);
                resolve();
            }
        }, 1000);
    
    
        // When consumer calls `cancel`:
        cancel = () => {
            // In case the promise has already resolved/rejected, don't run cancel behavior!
            if (finished) {
                return;
            }
    
            // Cancel-path scenario
            clearInterval(id);
            reject();
        };
    
        // If was cancelled before promise was launched, trigger cancel logic
        if (finished) {
            // (to avoid duplication, just calling `cancel`)
            cancel();
        }
    
    })
        // After any scenario, set `finished = true` so cancelling has no effect
        .then((resolvedValue) => {
            finished = true;
            return resolvedValue;
        })
        .catch((err) => {
            finished = true;
            return err;
        });

    return { promise, cancel };
}

function OnDocumentReady()
{
    let finished = false;
    
    const promise = new Promise((resolve, reject) => {
    
        const id = setInterval(() => {
            if(document.readyState === "complete" || (document.readyState !== "loading" && !document.documentElement.doScroll))
            {
                clearInterval(id);
                resolve();
            }
        }, 500);
    
    
        // When consumer calls `cancel`:
        cancel = () => {
            // In case the promise has already resolved/rejected, don't run cancel behavior!
            if (finished) {
                return;
            }
    
            // Cancel-path scenario
            clearInterval(id);
            reject();
        };
    
        // If was cancelled before promise was launched, trigger cancel logic
        if (finished) {
            // (to avoid duplication, just calling `cancel`)
            cancel();
        }
    
    })
        // After any scenario, set `finished = true` so cancelling has no effect
        .then((resolvedValue) => {
            finished = true;
            return resolvedValue;
        })
        .catch((err) => {
            finished = true;
            return err;
        });

    return { promise, cancel };
}

// window.onload = () => { init(); };