
let whiteSignMaterial;
      
var envMapTex = new THREE.TextureLoader().load( './images/textures/adams_place_bridge_1k.jpg' );

whiteSignMaterial  = new THREE.MeshStandardMaterial({
    color: '#fff',
    metalness : 0,
    roughness : 0.2,
    skinning : true,
    envMap: envMapTex,
    envMapIntensity: 0.3,
    transparent: true,
    side: THREE.FrontSide,
    opacity: 0,
});

AFRAME.registerComponent('sign-material', {
    schema: {
        src: {type: 'string', default: ""},
    },
	init: function () {

        var data = this.data;
        let redSignMaterial;

        var diffuseMap;
        if(data.src != "")
        {
            diffuseMap = new THREE.TextureLoader().load( data.src );
            diffuseMap.anisotropy = 8;

            redSignMaterial = new THREE.MeshStandardMaterial({
                color: '#fff',
                map: diffuseMap,
                metalness: 0,
                emissive : new THREE.Color( 1, 1, 1 ),
                emissiveIntensity: .03,
                emissiveMap : diffuseMap,
                roughness: 0.2,
                skinning: true,
                envMap: envMapTex,
                envMapIntensity: 0.3,
                transparent: true,
                side: THREE.FrontSide,
                opacity: 0,
            });
        }
        else
        {
            redSignMaterial = new THREE.MeshStandardMaterial({
                color: '#C10230',
                metalness: 0,
                roughness: 0.2,
                skinning: true,
                envMap: envMapTex,
                envMapIntensity: 0.3,
                transparent: true,
                side: THREE.FrontSide,
                opacity: 0,
            });
        }

        this.el.addEventListener('model-loaded', () => {
            // Grab the mesh / scene.
            const obj = this.el.getObject3D('mesh');
            // Go over the submeshes and modify materials we want.
            

            obj.traverse(node => {

                if(node.isMesh && node.name.includes("Icon_Red")) {
                    node.material = redSignMaterial;
                    node.castShadow = true;
                    node.receiveShadow = false;
                    node.renderOrder = 1;
                }
                else if(node.isMesh) {
                    node.material = whiteSignMaterial;
                    node.castShadow = true;
                    node.receiveShadow = false;
                    node.renderOrder = 1;
                }
            });
        });
      
    }
})