let dropShadowMaterial;

var colorMap = new THREE.TextureLoader().load( './images/textures/CoinShadow.png' );

dropShadowMaterial = new THREE.MeshBasicMaterial({
    map: colorMap,
    opacity: 0,
    transparent: true,
});

AFRAME.registerComponent('drop-shadow-material', {
	init: function () {

        const obj = this.el.getObject3D('mesh');
        // Go over the submeshes and modify materials we want.
        obj.traverse(node => {
            if(node.isMesh) {
                node.material = dropShadowMaterial;
            }
        });
    }
})