let markerMaterial;

var colorMap = new THREE.TextureLoader().load( './images/textures/StopMarker_Diffuse.png' );
colorMap.anisotropy = 8;

markerMaterial = new THREE.MeshBasicMaterial({
    map: colorMap,
    color: '#fff',
    opacity: 0,
    transparent: true,
});

AFRAME.registerComponent('marker-material', {
	init: function () {

        this.el.addEventListener('model-loaded', () => {

            console.log('mesh loaded');
            // Grab the mesh / scene.
            const obj = this.el.getObject3D('mesh');
            // Go over the submeshes and modify materials we want.
            obj.traverse(node => {
                if(node.isMesh) {
                    node.material = markerMaterial;
                }
            });
            var event = new CustomEvent('material-loaded');
            this.el.dispatchEvent(event);
        });
    }
})

AFRAME.registerComponent('model-opacity', {
    schema: {default: 1.0},
    init: function () {
        this.el.addEventListener('model-loaded', this.update.bind(this));
    },
    update: function () {
        var mesh = this.el.getObject3D('mesh');
        var data = this.data;
        if (!mesh) { return; }
        mesh.traverse(function (node) {
            if (node.isMesh) {
            node.material.opacity = data;
            node.material.needsUpdate = true;
            }
        });
    }
});